/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.inventory;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import java.lang.ref.WeakReference;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import slimeknights.tconstruct.library.recipe.fuel.IFluidContainer;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;

public class MelterFuelWrapper
implements IFluidContainer {
    private final WeakReference<FluidTank> tank;

    public MelterFuelWrapper(FluidTank tank) {
        this.tank = new WeakReference<FluidTank>(tank);
    }

    public boolean isValid() {
        return this.tank.get() != null;
    }

    @Override
    public class_3611 getFluid() {
        return Optional.ofNullable((FluidTank)this.tank.get()).map(FluidTank::getFluid).map(FluidStack::getFluid).orElse(class_3612.field_15906);
    }

    public FluidStack getFluidStack() {
        return Optional.ofNullable((FluidTank)this.tank.get()).map(FluidTank::getFluid).orElse(FluidStack.EMPTY);
    }

    public long getCapacity() {
        return Optional.ofNullable((FluidTank)this.tank.get()).map(FluidTank::getCapacity).orElse(0L);
    }

    public long consumeFuel(MeltingFuel fuel) {
        long amount;
        FluidTank tank = (FluidTank)this.tank.get();
        if (tank != null && (amount = fuel.getAmount(this)) > 0L) {
            long drained;
            try (Transaction tx = TransferUtil.getTransaction();){
                drained = tank.extract((FluidVariant)tank.getResource(), amount, (TransactionContext)tx);
                tx.commit();
            }
            int duration = fuel.getDuration();
            if (drained < amount) {
                return (long)duration * drained / amount;
            }
            return duration;
        }
        return 0L;
    }
}

